/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.jdk8;

import dev.compactmods.crafting.lib.reactivex.rxjava3.annotations.NonNull;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Function;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Supplier;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.DisposableHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.jdk8.ObservableFromStream;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public final class ObservableFlatMapStream<T, R>
extends Observable<R> {
    final Observable<T> source;
    final Function<? super T, ? extends Stream<? extends R>> mapper;

    public ObservableFlatMapStream(Observable<T> source, Function<? super T, ? extends Stream<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        if (this.source instanceof Supplier) {
            Stream<? extends R> stream = null;
            try {
                Object t = ((Supplier)((Object)this.source)).get();
                if (t != null) {
                    stream = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Stream");
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptyDisposable.error(ex, observer);
                return;
            }
            if (stream != null) {
                ObservableFromStream.subscribeStream(observer, stream);
            } else {
                EmptyDisposable.complete(observer);
            }
        } else {
            this.source.subscribe(new FlatMapStreamObserver<T, R>(observer, this.mapper));
        }
    }

    static final class FlatMapStreamObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -5127032662980523968L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends Stream<? extends R>> mapper;
        Disposable upstream;
        volatile boolean disposed;
        boolean done;

        FlatMapStreamObserver(Observer<? super R> downstream, Function<? super T, ? extends Stream<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(@NonNull Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(@NonNull T t) {
            if (this.done) {
                return;
            }
            try (Stream<R> stream = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Stream");){
                Iterator it = stream.iterator();
                while (it.hasNext()) {
                    if (this.disposed) {
                        this.done = true;
                    } else {
                        Object value = Objects.requireNonNull(it.next(), "The Stream's Iterator.next returned a null value");
                        if (this.disposed) {
                            this.done = true;
                        } else {
                            this.downstream.onNext(value);
                            if (!this.disposed) continue;
                            this.done = true;
                        }
                    }
                    break;
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.dispose();
                this.onError(ex);
            }
        }

        @Override
        public void onError(@NonNull Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError(e);
            } else {
                this.done = true;
                this.downstream.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

